/**
*Resource Managager class
*For working AWS S3 buckets
**/


function ResourceManager(callback)
{
   //this.s3 = new AWS.S3({accessKeyId: 'AKIAI2BB3YRDUZRDATTQ', secretAccessKey: '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',region:'us-east-1'});
   //this.s3 = new AWS.S3()
   this.bucket='hmsresource';
   var self=this;

   this.init=function(){
     this.s3 = new AWS.S3();
     var getObjectPromise = self.s3.getObject({Bucket: self.bucket,Key:'contents/'}).promise();
     getObjectPromise.then(function(data){
         console.log("Access Key:", AWS.config.credentials.accessKeyId);
         callback();
     },
     function(error){
        alert("Resource Error:"+error);
     })
   }

   self.init();
   //authenicateUser();

   this.getCredentials=function(f,arg){
      if(AWS.config.credentials.expired){
         AWS.config.credentials.get(function(err) {
            if (err) console.log(err.stack); // credentials not loaded
            else{
               console.log("Access Key:", AWS.config.credentials.accessKeyId);
               //self.getResource(args);
               keepAlive(f,arg);
            }
         })
      }
   }

   this.keepAlive=function(f,arg){
        this.s3 = new AWS.S3();
        var getObjectPromise = self.s3.getObject({Bucket: self.bucket,Key:'contents/'}).promise();
        getObjectPromise.then(function(data){
            console.log("Created new S3 service object:", AWS.config.credentials.accessKeyId);
            f(arg);
        },
        function(error){
           alert("Resource Error:"+error);
        })
   }



   this.getResource=function(dir)
   {
      self.getCredentials(this,dir);
      console.log(AWS.config.credentials.expired)
      if(dir)key=dir.replace('./','');
      resource="";
      self.s3.getSignedUrl('getObject', {Bucket:self.bucket, Key:key}, function (err, url) {
         if(err){
             console.log(err);
             console.log("retrying...");
             self.init();

         }
         else resource=url;
      });
      return resource;
   }

   this.getFiles=function(directory,item)
   {
       var key=directory+"/";
       self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
          if (err) alert(err+" "+err.stack);
          else vm.directory.display(data,directory,item);
       })
   }

   this.newDirectory=function(directory,name)
   {
       var key=directory+"/"+name+"/";
       self.s3.putObject({Bucket:self.bucket, Key:key},function(err){
          if (err) alert(err+" "+err.stack);
          else self.getFiles(directory,name);
       })
   }

   this.deleteObjects=function(directory,keys)
   {
       for(i=0;i<keys.length;i++){
         self.s3.deleteObject({Bucket:self.bucket, Key:keys[i]}, function(err, data) {
            if (err) alert(err+" "+err.stack);
            else self.getFiles(directory);
         });
       }

   }

   this.pasteObjects=function(from,to,mode,items)
   {
       alert(from+" "+to+" "+mode+" ");
       for(i=0;i<items.length;i++){
         var key=from+"/"+items[i].path;
         var name=items[i].path;
         var type=items[i].type;
         self.copyRecursive(key,name,type,to);
       }
       //if mode=cut then delete 'from' object
   }

   this.copyRecursive=function(key,name,type,to){
       //alert(key+" "+type+" "+to);
       var copyto=to+"/"+name;
       alert(key+" "+copyto);
       if(type=="file"){

         self.s3.copyObject({Bucket:self.bucket,CopySource:key,Key:copyto}, function(err, data) {
            if (err) alert(err+" "+err.stack);
            else{
                alert(JSON.stringify(data,null,2));
            }
         });

        /* var file=null;
         var contentType="";
         self.s3.getObject({Bucket:self.bucket,Key:key}, function(err, data) {
            if (err) alert(err+" "+err.stack);
            else{
                alert(JSON.stringify(data,null,2));
                contentType=data.ContentType;                                  
                file=new File(data.Body.data, name, {type: contentType});
            }
         });
         var key=to+"/"+name;
         self.s3.putObject({Bucket:self.bucket,Key:key,ContentType: contentType, Body: file,ContentLength:100}, function(err, data) {
            if (err) alert(err+" "+err.stack);
            else{
                alert("copied");
            }
         }); */
       }

   }

   this.uploadFiles=function(directory,files)
   {
        var key=directory+"/"
        for(i=0;i<files.length;i++){
           self.s3.upload({Bucket:self.bucket,Key: key+files[i].name, ContentType: files[i].type, Body: files[i]}, function (err, data) {
              if (err) alert(err+" "+err.stack);
              else{
                 self.getFiles(directory,files[files.length-1].name);
              }
           });
        }

   }

   this.savePhoto=function(video,directory,photo)
   {
        var video=video;
        var index=video.data('index');
        self.s3.upload({Bucket:self.bucket,Key: directory+"/photo"+index+".jpg", ContentType: "image/jpeg", Body: photo}, function (err, data) {
           if (err) alert(err+" "+err.stack);
           else{
              video.data('photo').updatePhoto(video.data('index'),directory+"/photo"+index+".jpg");
           }
        });

   }

   this.uploadReport=function(context,index,directory,file)
   {
         self.s3.upload({Bucket:self.bucket,Key: directory+file.name, ContentType: file.type, Body: file}, function (err, data) {
            if (err) alert(err+" "+err.stack);
            else{
               //self.getFiles(directory,files[files.length-1].name);
               context.updateReport(index,directory+file.name);
            }
         });

   }

   this.uploadNDT=function(recordid,ssiid,file)
   {
         var directory="NDT/"+recordid+"/"+ssiid+"/";
         try{
         self.s3.upload({Bucket:self.bucket,Key:directory+file.name, ContentType: file.type, Body: file, Metadata:{"Owner":username}}, function (err, data) {
            if (err) alert(err+" "+err.stack);
            else{
               uploaded(file.name,recordid,ssiid,file.size);
            }
         });
         }
         catch(e){
            alert(e);
         }

   }

   this.deleteNDT=function(key,id)
   {
      self.s3.deleteObject({Bucket:self.bucket, Key:key}, function(err, data) {
         if (err) alert(err+" "+err.stack);
         else{
            try{
            deleteFileRecord(id);
            }
            catch(e){
               alert(e);
            }
         }
      });
   }

   this.getNDTRawFiles=function(directory)
   {
       var key=directory+"/";
       self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
          if (err) alert(err+" "+err.stack);
          else{
             alert(JSON.stringify(data.Contents));
             for(i in data.Contents){
                self.getObject(data.Contents[i].Key);
             }
          }
       })
   }

   this.getObject=function(key)
   {
      self.s3.getObject({Bucket:self.bucket,Key:key}, function(err, data) {
         if (err) alert(err+" "+err.stack);
         else alert(JSON.stringify(data.Metadata.Owner));
      })
   }

   this.getNDTReports=function(directory,ele)
   {
       var key=directory+"/";
       self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
          if (err) alert(err+" "+err.stack);
          else displayNDTRecords(ele,data);
       })
   }

   this.uploadNDTReports=function(recordid,ssiid,file)
   {
         var directory="NDT/"+recordid+"/"+ssiid+"/reports/";
         self.s3.upload({Bucket:self.bucket,Key:directory+file.name, ContentType: file.type, Body: file}, function (err, data) {
            if (err) alert(err+" "+err.stack);
            else{
            }
         });

   }

   this.clearNDTReports=function(key)
   {
       self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
         if (err) alert(err+" "+err.stack);
         else{
            //alert(JSON.stringify(data));
            if (data.Contents.length > 0){
               params = {Bucket: self.bucket};
               params.Delete = {Objects:[]};
               data.Contents.forEach(function(content) {
                  params.Delete.Objects.push({Key: content.Key});
               });
               alert(JSON.stringify(params.Delete.Objects));
               try{
               self.s3.deleteObjects(params, function(err, data) {
                  if (err) alert(err+" "+err.stack);
                  else{
                     //delete top level folder
                     self.s3.deleteObject({Bucket:self.bucket, Key:key}, function(err, data) {
                        if (err) alert(err+" "+err.stack);
                        else submitFiles();
                     })
                  }
               });
               }
               catch(e){
                  alert(e)
               }
            }
            else submitFiles();
         }
       });
   }

   this.refreshAll=function(){
        AWS.config.region = 'us-east-1'; // Region
        AWS.config.credentials = new AWS.CognitoIdentityCredentials({
          IdentityPoolId: 'us-east-1:1f59e4c7-fee3-42f4-bb6e-3ca5edc287cd'
        });
       AWSCognito.config.region = 'us-east-1';
       AWSCognito.config.credentials = new AWS.CognitoIdentityCredentials({
          IdentityPoolId: 'us-east-1:1f59e4c7-fee3-42f4-bb6e-3ca5edc287cd'
       });
       var poolData = { UserPoolId : 'us-east-1_l5tCBR3sI',
          ClientId : '2vuvoj0dtqku542675dee2pd7k'
       };
       var userPool = new AWSCognito.CognitoIdentityServiceProvider.CognitoUserPool(poolData);
       cognitoUser = userPool.getCurrentUser();
       if (cognitoUser != null) {
           cognitoUser.getSession(function(err, result) {
           if (result) {
               console.log('Cognito user refreshed.');
               userAccess=result.getIdToken().getJwtToken();
               // Add the User's Id Token to the Cognito credentials login map.
               AWS.config.credentials = new AWS.CognitoIdentityCredentials({
                   IdentityPoolId: 'us-east-1:1f59e4c7-fee3-42f4-bb6e-3ca5edc287cd',
                   Logins: {
                      'cognito-idp.us-east-1.amazonaws.com/us-east-1_l5tCBR3sI': result.getIdToken().getJwtToken()
                   }
                 });
               AWS.config.credentials.refresh(function(err) {
                   if (err) console.log("Error refreshing credentials:"+err);
                   else console.log("credentials refreshed");
               });
           }
           })
       }
   }
}